{********************************************
; File: ProDOS.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT PRODOS;
INTERFACE
USES TYPES;
CONST

{ Error Codes }
invalidCallNum = $0001;  { invalid call number }
unclaimedIntErr = $01;  { fatal error - unclaimed interrupt }
badPBlockPtr = $05;  { call pointer out of bounds }
pdosActiveErr = $06;  { ProDOS is active }
pdosBusyErr = $07;  { ProDOS is busy }
vcbUnusable = $0A;  { fatal error - VCB unusable }
fcbUnusable = $0B;  { fatal error - FCB unusable }
badBlockZero = $0C;  { fatal error - block zero allocated illegally }
shdwInterruptErr = $0D;  { fatal error - interrupt occured while I/O shadowing off }
{$IFC UNDEFINED devNotFound }  { device not found }
devNotFound = $10;
{$SETC devNotFound := 0}
{$ENDC}
badDevRefNum = $11;  { invalid device reference number }
osVersionErr = $11;  { Wrong OS version }
badReqCode = $20;  { invalid request code }
intTableFull = $25;  { interrupt table full }
invalidOperation = $26;  { invalid operation }
ioError = $27;  { I/O error }
noDevConnect = $28;  { no device connected }
writeProtectErr = $2B;  { write protect error }
diskSwitchErr = $2E;  { disk switched error }
badPathname = $40;  { invalid pathname syntax }
fcbFullErr = $42;  { FCB full error }
badFileRefNum = $43;  { invalid file reference number }
{$IFC UNDEFINED pathNotFound }  { path not found }
pathNotFound = $44;
{$SETC pathNotFound := 0}
{$ENDC}
volumeNotFound = $45;  { volume not found }
{$IFC UNDEFINED fileNotFound }  { file not found }
fileNotFound = $46;
{$SETC fileNotFound := 0}
{$ENDC}
dupFileName = $47;  { duplicate file name }
volumeFullErr = $48;  { volume full error }
dirFullErr = $49;  { directory full error }
versionErr = $4A;  { version error (incompatible file format) }
{$IFC UNDEFINED badStoreType }  { unsupported (or incorrect) storage type }
badStoreType = $4B;
{$SETC badStoreType := 0}
{$ENDC}
{$IFC UNDEFINED eofEncountered }  { end-of-file encountered }
eofEncountered = $4C;
{$SETC eofEncountered := 0}
{$ENDC}
positionRangeErr = $4D;  { position out of range }
accessErr = $4E;  { access not allowed }
fileOpenErr = $50;  { file is open }
dirDamaged = $51;  { directory structure is damaged }
badVolType = $52;  { unsupported volume type }
{$IFC UNDEFINED paramRangeErr }  { parameter out of range }
paramRangeErr = $53;
{$SETC paramRangeErr := 0}
{$ENDC}
memoryFullErr = $54;  { out of memory }
vcbFullErr = $55;  { VCB full error }
dupVolumeErr = $57;  { duplicate volume error }
notBlkDevErr = $58;  { not a blocked device }
{$IFC UNDEFINED invalidLevel }  { invalid level }
invalidLevel = $59;
{$SETC invalidLevel := 0}
{$ENDC}
blkNumRangeErr = $5A;  { block number out of range }
notSameVolErr = $5B;  { different volumes found on ChangePath call }
notExecSysFile = $5C;  { not an executable system file }
osUnavailable = $5D;  { Operating System/file system not available }
deallocateRamErr = $5E;  { Cannot deallocate /RAM }
{$IFC UNDEFINED stackOverflow }  { Return stack overflow }
stackOverflow = $5F;
{$SETC stackOverflow := 0}
{$ENDC}
dataUnavailable = $60;  { Data unavailable }

{ Other Constants }
endofDirectory = $0061;
P_READ_ENABLE = $01;
P_WRITE_ENABLE = $02;
P_DESTROY_ENABLE = $80;
P_RENAME_ENABLE = $40;
TYPE
BlockRecPtr = ^BlockRec;
BlockRec = RECORD
    blockDevNum : Integer;
    blockDataBuffer : Ptr;
    blockNum : Longint;
END;
DevNumRecPtr = ^DevNumRec;
DevNumRec = RECORD
    devName : Ptr;
    devNum : Integer;
END;
DInfoRecPtr = ^DInfoRec;
DInfoRec = RECORD
    devNum : Integer;
    devName : Ptr;
END;
DirEntryRecPtr = ^DirEntryRec;
DirEntryRec = RECORD
    refNum : Integer;
    flags : Integer;
    base : Integer;
    displacement : Integer;
    nameBuffer : Ptr;
    entryNum : Integer;
    fileType : Integer;
    endOfFile : Longint;
    blockCount : Longint;
    createTime : TimeRec;
    modTime : TimeRec;
    access : Integer;
    auxType : Longint;
    fileSysID : Integer;
END;
EOFRecPtr = ^EOFRec;
EOFRec = RECORD
    eofRefNum : Integer;
    eofPosition : Longint;
END;
FileIORecPtr = ^FileIORec;
FileIORec = RECORD
    fileRefNum : Integer;
    dataBuffer : Ptr;
    requestCount : Longint;
    transferCount : Longint;
END;
FileRecPtr = ^FileRec;
FileRec = RECORD
    pathname : Ptr;
    fAccess : Integer;
    fileType : Integer;
    auxType : Longint;
    storageType : Integer;
    createDate : Integer;
    createTime : Integer;
    modDate : Integer;
    modTime : Integer;
    blocksUsed : Longint;
END;
FormatRecPtr = ^FormatRec;
FormatRec = RECORD
    devName : Ptr; { device name pointer }
    volName : Ptr; { device name pointer }
    fileSysID : Integer; { file system ID }
END;
EraseDiskRecPtr = ^EraseDiskRec;
EraseDiskRec = RECORD
    devName : Ptr; { device name pointer }
    volName : Ptr; { device name pointer }
    fileSysID : Integer; { file system ID }
END;
InterruptRecPtr = ^InterruptRec;
InterruptRec = RECORD
    intNum : Integer;
    intCode : Ptr;
END;
MarkRecPtr = ^MarkRec;
MarkRec = RECORD
    markRefNum : Integer;
    position : Longint;
END;
NewLineRecPtr = ^NewLineRec;
NewLineRec = RECORD
    newLRefNum : Integer;
    enableMask : Integer;
    newlineChar : Integer;
END;
OpenRecPtr = ^OpenRec;
OpenRec = RECORD
    openRefNum : Integer;
    openPathname : Ptr;
    ioBuffer : Handle;
END;
PathNameRecPtr = ^PathNameRec;
PathNameRec = RECORD
    pathname : Ptr;
    newPathname : Ptr;
END;
PrefixRecPtr = ^PrefixRec;
PrefixRec = RECORD
    prefixNum : Integer;
    prefix : Ptr;
END;
QuitRecPtr = ^QuitRec;
QuitRec = RECORD
    quitPathname : Ptr;
    flags : Integer;
END;
VolumeRecPtr = ^VolumeRec;
VolumeRec = RECORD
    deviceName : Ptr;
    volName : Ptr;
    totalBlocks : Longint;
    freeBlocks : Longint;
    fileSysID : Integer;
END;
PROCEDURE ALLOC_INTERRUPT (VAR pBlockPtr:InterruptRec);
INLINE $0031F4,$E100B022,$8F,'_toolErr';
PROCEDURE CHANGE_PATH (VAR pBlockPtr:PathNameRec);
INLINE $0004F4,$E100B022,$8F,'_toolErr';
PROCEDURE CLEAR_BACKUP_BIT (VAR pBlockPtr:PathNameRec);
INLINE $000BF4,$E100B022,$8F,'_toolErr';
PROCEDURE CLOSEPD (VAR pBlockPtr:FileIORec);
INLINE $0014F4,$E100B022,$8F,'_toolErr';
PROCEDURE CREATE (VAR pBlockPtr:FileRec);
INLINE $0001F4,$E100B022,$8F,'_toolErr';
PROCEDURE D_INFO (VAR pBlockPtr:DInfoRec);
INLINE $002CF4,$E100B022,$8F,'_toolErr';
PROCEDURE DEALLOC_INTERRUPT (VAR pBlockPtr:InterruptRec);
INLINE $0032F4,$E100B022,$8F,'_toolErr';
PROCEDURE DESTROY (VAR pBlockPtr:PathNameRec);
INLINE $0002F4,$E100B022,$8F,'_toolErr';
PROCEDURE ERASE_DISK (VAR pBlockPtr:EraseDiskRec);
INLINE $0025F4,$E100B022,$8F,'_toolErr';
PROCEDURE FLUSH (VAR pBlockPtr:FileIORec);
INLINE $0015F4,$E100B022,$8F,'_toolErr';
PROCEDURE FORMAT (VAR pBlockPtr:FormatRec);
INLINE $0024F4,$E100B022,$8F,'_toolErr';
PROCEDURE GET_BOOT_VOL (VAR pBlockPtr:PathNameRec);
INLINE $0028F4,$E100B022,$8F,'_toolErr';
PROCEDURE GET_DEV_NUM (VAR pBlockPtr:DevNumRec);
INLINE $0020F4,$E100B022,$8F,'_toolErr';
PROCEDURE GET_DIR_ENTRY (VAR pBlockPtr:DirEntryRec);
INLINE $001CF4,$E100B022,$8F,'_toolErr';
PROCEDURE GET_EOF (VAR pBlockPtr:EOFRec);
INLINE $0019F4,$E100B022,$8F,'_toolErr';
PROCEDURE GET_FILE_INFO (VAR pBlockPtr:FileRec);
INLINE $0006F4,$E100B022,$8F,'_toolErr';
PROCEDURE GET_LAST_DEV (VAR pBlockPtr:Integer);
INLINE $0021F4,$E100B022,$03B0,$0000A9,$8F,'_toolErr';
PROCEDURE GET_LEVEL (VAR pBlockPtr:IntPtr);
INLINE $001BF4,$E100B022,$8F,'_toolErr';
PROCEDURE GET_MARK (VAR pBlockPtr:MarkRec);
INLINE $0017F4,$E100B022,$8F,'_toolErr';
PROCEDURE GET_NAME (VAR pBlockPtr:PathNameRec);
INLINE $0027F4,$E100B022,$8F,'_toolErr';
PROCEDURE GET_PREFIX (VAR pBlockPtr:PrefixRec);
INLINE $000AF4,$E100B022,$8F,'_toolErr';
PROCEDURE GET_VERSION (VAR pBlockPtr:Integer);
INLINE $002AF4,$E100B022,$8F,'_toolErr';
PROCEDURE NEWLINE (VAR pBlockPtr:NewLineRec);
INLINE $0011F4,$E100B022,$8F,'_toolErr';
PROCEDURE OPENPD (VAR pBlockPtr:OpenRec);
INLINE $0010F4,$E100B022,$8F,'_toolErr';
PROCEDURE QUIT (VAR pBlockPtr:QuitRec);
INLINE $0029F4,$E100B022,$8F,'_toolErr';
PROCEDURE READ_BLOCK (VAR pBlockPtr:BlockRec);
INLINE $0022F4,$E100B022,$8F,'_toolErr';
PROCEDURE READPD (VAR pBlockPtr:FileIORec);
INLINE $0012F4,$E100B022,$8F,'_toolErr';
PROCEDURE SET_EOF (VAR pBlockPtr:EOFRec);
INLINE $0018F4,$E100B022,$8F,'_toolErr';
PROCEDURE SET_FILE_INFO (VAR pBlockPtr:FileRec);
INLINE $0005F4,$E100B022,$8F,'_toolErr';
PROCEDURE SET_LEVEL (VAR pBlockPtr:Integer);
INLINE $001AF4,$E100B022,$03B0,$0000A9,$8F,'_toolErr';
PROCEDURE SET_MARK (VAR pBlockPtr:MarkRec);
INLINE $0016F4,$E100B022,$8F,'_toolErr';
PROCEDURE SET_PREFIX (VAR pBlockPtr:PrefixRec);
INLINE $0009F4,$E100B022,$8F,'_toolErr';
PROCEDURE VOLUME (VAR pBlockPtr:VolumeRec);
INLINE $0008F4,$E100B022,$8F,'_toolErr';
PROCEDURE WRITE_BLOCK (VAR pBlockPtr:BlockRec);
INLINE $0023F4,$E100B022,$8F,'_toolErr';
PROCEDURE WRITEPD (VAR pBlockPtr:FileIORec);
INLINE $0013F4,$E100B022,$8F,'_toolErr';
IMPLEMENTATION
END.
